% ALPHA ENGINE DEFINITION
% Generated 25-Sep-2023 09:23:33

% SUGGESTED CITATION:
% VW 1.5L TSI evo Hybrid Concept 4 Engine from 2019 Aachen Paper - ALPHA Map Package. Version 2023-09. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'VW 1.5L TSI evo Hybrid Concept 4 Engine from 2019 Aachen Paper Octane Modified for Tier 3 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.5; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  15; 
engine.inertia_kgm2 =  0.095; 
engine.bore_mm =  74.5; 
engine.stroke_mm =  85.9; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     86.584924878581461	;     104.45306647121383	;     123.63511815660482	;     127.92167030952929	;     137.03244055371584	;     142.85064657677677	;     147.98511843379339	;     152.17770112445353	;     158.05749119675107	;     161.52399842725848	;     162.07921113770038	;     168.07886567504681	;     174.31551973479139	;     175.65894408857764	;     180.55593949186317	;     180.59028395851186	;     188.71596841071417	;     194.24962774891236	;     195.89532154332929	;     199.23117348274479	;     203.84583148998661	;     210.06178382217320	;     211.80201771006386	;     215.80439287180440	;     218.58724347517915	;     224.07035973463042	;     230.58653904498416	;     231.13018956267589	;     232.54366385964704	;     236.52653479613309	;     238.13321366514725	;     248.99478553510880	;     250.33177455461757	;     252.29912211889246	;     269.71046559213073	;     288.86645924444383	;     290.99923581968289	;     309.70105563145296	;     312.28740821855246	;     319.83082477670564	;     322.26440450117832	;     335.07956774501201	;     418.34564307702743	;     458.88232251027762	;     481.82643863579153	;     504.77055476130545		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     75.678392000000002	;     98.994975000000011	;     117.23131543572030	;     120.71049974633623	;     129.40256596347459	;     134.85470059947170	;     139.73307515893120	;     143.71303159171350	;     149.73730903902964	;     152.69397238775787	;     153.22930625350500	;     158.81103240493280	;     165.11553061536301	;     166.44560264169957	;     170.86280178532934	;     170.88731993863450	;     176.40107227015022	;     180.23720704550112	;     181.31587917225636	;     183.50550295961023	;     186.48132744523565	;     190.78000904061832	;     191.80676785674297	;     194.26403587978027	;     195.95959699027856	;     199.39286843714478	;     203.68909026674095	;     204.02549819552678	;     204.57088024711049	;     205.97254132433827	;     206.41230020851071	;     209.19712967042454	;     209.47691743691050	;     209.76740524810285	;     211.88768152646082	;     214.13797864155197	;     214.45140117983129	;     217.36282724038222	;     217.78331928686239	;     219.18587818737947	;     219.68838356755774	;     220.40378266734433	;     220.60301500000000	;     214.17085400000002	;     183.57501771428574	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     504.77055476130545		]; 
engine.naturally_aspirated_torque_Nm = [	     107.42958658702935	    107.42958658702935		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     504.77055476130545	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -11.963636363636365	;    -26.298382881204969	;    -30.940805307063979		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     24.054479271641839	;     48.108958543283677	;     72.163437814925516	;     96.217917086567354	;     110.17646365311489	;     120.68053745272778	;     137.03244055371584	;     147.98511843379339	;     162.07921113770038	;     180.55593949186317	;     194.24962774891236	;     199.23117348274479	;     215.80439287180440	;     232.54366385964704	;     238.13321366514725	;     252.29912211889246	;     269.71046559213073	;     290.99923581968289	;     309.70105563145296	;     322.26440450117832	;     335.07956774501201	;     351.72608097568400	;     375.08858063138382	;     399.25939424953697	;     415.76236111005107	;     433.28718350433974	;     450.24998535205691	;     455.05270636115267	;     465.31383902216760	;     504.77055476130545		]; 
engine.fuel_map_torque_Nm = [	    -34.163181818181819	;    -7.8890442805194816	;     18.385093257142856	;     33.605260749999999	;     42.293850979166663	;     50.982441208333327	;     58.528427982758629	;     66.912857631944433	;     76.551467944444454	;     84.119684616071424	;     93.088071166666651	;     102.94732440624999	;     110.70234099999999	;     117.56781862500000	;     128.78643099999999	;     134.24749144999998	;     141.11854344444441	;     146.98996679999999	;     153.54515060000000	;     159.86622083333333	;     164.43701233333334	;     168.56187299999999	;     172.57525100000001	;     177.25752499999999	;     181.54960966666667	;     185.17279833333333	;     189.91081383333332	;     193.47826087499999	;     198.36120390000002	;     207.98274960526314	;     215.21739114285714	;     218.00445966666666	;     231.63316575000002		]; 
engine.fuel_map_gps = [
 -0.013707006216171408	 -0.051607464655462974	 -0.077182060604751523	 -0.092742485410861039	  -0.10797096752567434	  -0.11660179413577439	  -0.12301305109768600	  -0.13280512872003147	  -0.13919631647010897	  -0.14721169183632987	  -0.15717854083162694	  -0.16410047601188654	  -0.16655468112585819	  -0.17442487603937146	  -0.18156561772543264	  -0.18381385966358665	  -0.18923240071031172	  -0.19495121601906293	  -0.20010758687435759	  -0.20285496934104960	  -0.20397318721439403	  -0.20463834871322020	  -0.20471571400326474	  -0.20301852319093427	  -0.19923688835705566	  -0.19598112980896149	  -0.19217394202800225	  -0.18826660623159530	  -0.18714557307257290	  -0.18473765958549368	  -0.17509003291871214	;
-0.0055084810425625784	-0.00016196716379392753	  0.017856485142924403	  0.035388926378931131	  0.052066930008101829	  0.061305604709790219	  0.068104204049034153	  0.078392477795832166	  0.085097950576490805	  0.093569528213948761	   0.10455024407891531	   0.11289328862263040	   0.11598861952793209	   0.12660658037184458	   0.13829518073455788	   0.14234752314536231	   0.15292669563802086	   0.16692282073741072	   0.18612482275491801	   0.20549563259592743	   0.21981588097292176	   0.23529989332412310	   0.25676453728004117	   0.28994054167185235	   0.32834083818964394	   0.35645608805111906	   0.38755522053314762	   0.41859347438131389	   0.42744764763548726	   0.44642233946278220	   0.52105048472033044	;
 0.0036492006036985777	  0.055151325084639782	   0.10633700932028947	   0.15677056168566272	   0.20599092972666375	   0.23446052561175254	   0.25597358727975766	   0.28897845173267189	   0.30954362636240035	   0.33438465508859572	   0.36506899624938943	   0.38809973192590774	   0.39674729228731631	   0.42708211247110373	   0.46151179678834026	   0.47341615217617727	   0.50434482309681605	   0.54262277337187226	   0.58820890116424318	   0.62912525838844879	   0.65994277957411296	   0.69236962188220941	   0.73344375214434498	   0.78769247783777818	   0.84718287978129614	   0.89559350216169686	   0.95508409917439718	    1.0166756791478413	    1.0341101194720344	    1.0711247254245688	    1.2031434149057871	;
  0.019356833675436870	  0.087508289789008376	   0.15524120332726304	   0.22183108717555922	   0.28688527715264989	   0.32454069503830973	   0.35262061064939881	   0.39475048317406042	   0.42188033128223795	   0.45622603870020867	   0.50076884328226878	   0.53432301101184121	   0.54663859323053265	   0.58821721746382571	   0.63230289326030742	   0.64762190148133447	   0.68757701834213836	   0.73966366145529405	   0.80640544167606965	   0.86355391839431306	   0.90178739401044106	   0.94168268936638055	   0.99558810351178051	    1.0742285370397513	    1.1557291546674562	    1.2158133011304186	    1.2837437650990162	    1.3515972392136271	    1.3711109418826075	    1.4127178109200300	    1.5663717396428503	;
  0.030723305815963123	   0.10680252023134516	   0.18281949693178323	   0.25828853444395672	   0.33130768884219336	   0.37270019881273292	   0.40337822915524046	   0.44970192120084540	   0.47969878892899614	   0.51750743311783076	   0.56660311154696585	   0.60408274452578492	   0.61793783581181694	   0.66509643929970852	   0.71557282081753670	   0.73289214697425509	   0.77769719313449504	   0.83512525343284782	   0.90800679993086186	   0.97350263532658277	    1.0184704740059327	    1.0652292054900834	    1.1276115292337845	    1.2184687511652619	    1.3152680803383319	    1.3840962376307238	    1.4591319622635541	    1.5334435954141490	    1.5546846629316116	    1.5999780170766014	    1.7703292837331388	;
  0.044431964809636119	   0.12714170810510481	   0.20983848273876890	   0.29214834747630780	   0.37305954773187749	   0.41901601269541144	   0.45313299315815264	   0.50508493055318848	   0.53878453776680957	   0.58093876933355004	   0.63468597137289040	   0.67699667999802005	   0.69279729786068700	   0.74705182214558052	   0.80439817480516884	   0.82386734357196356	   0.87386174713791109	   0.93710762282854321	    1.0162476272480736	    1.0879568029136952	    1.1378373993132482	    1.1907244727463606	    1.2613697468200118	    1.3631628615824307	    1.4703096994755240	    1.5461240955182216	    1.6290622788525317	    1.7109750464805040	    1.7342200841019650	    1.7839058789335407	    1.9741532823068777	;
  0.058986494126213464	   0.14645965494324217	   0.23392587808584497	   0.32128842959384951	   0.40837768566558758	   0.45866698504768461	   0.49635516996157591	   0.55452249354885430	   0.59292896099538084	   0.64171364886142968	   0.70419444614186411	   0.75233086732062515	   0.77023035414894347	   0.83140850184571657	   0.89549250031897953	   0.91704713094428503	   0.97193072285891502	    1.0402098992430644	    1.1254673690146129	    1.2028663532225066	    1.2564375606091016	    1.3127024642561447	    1.3877076266717863	    1.4963785766607400	    1.6085656193178268	    1.6887301075299921	    1.7788086699459977	    1.8673302238989653	    1.8924026376745640	    1.9459693129551530	    2.1525282171572040	;
  0.078814573884990191	   0.20636638727978956	   0.26687744597112895	   0.35525725680021103	   0.44851799033125783	   0.50347925887749878	   0.54501893158014691	   0.60948710438056075	   0.65262836681554837	   0.70859676299348329	   0.78291094652798932	   0.83923475852392693	   0.85993081460497744	   0.92953606132336764	    1.0006474247880490	    1.0244679154733027	    1.0850146822486137	    1.1604542581669652	    1.2555172823016238	    1.3422444437399863	    1.4011750710915862	    1.4613734138207670	    1.5401351422264018	    1.6539912947401714	    1.7740611681326548	    1.8595326752764900	    1.9547640990549762	    2.0477884223650524	    2.0742076528970648	    2.1307513841768730	    2.3537713052067422	;
   0.13057948725270818	   0.27837090783344226	   0.32438837270412296	   0.40672700191164474	   0.50039588399875379	   0.55988280335874863	   0.60536593235992109	   0.67725895761264632	   0.72634603070265313	   0.79050021133213610	   0.87592552415086800	   0.93954665965145945	   0.96270100723344854	    1.0397800584417296	    1.1181250573834205	    1.1444598970633044	    1.2116733677269329	    1.2963375571283933	    1.4031884162587225	    1.4990884124720947	    1.5639669149010409	    1.6303198490492712	    1.7169252107312800	    1.8408990821885058	    1.9733664060566329	    2.0663297310702888	    2.1674303778523476	    2.2668927017887319	    2.2950464083906628	    2.3552410541623714	    2.5919281653920097	;
   0.21141068768762231	   0.36149559433737111	   0.38850439316886731	   0.46408166570678250	   0.55578309787913194	   0.61309670717303844	   0.65876757205690839	   0.73592777451210145	   0.78926856594014816	   0.85887963680070178	   0.95128955434885387	    1.0197134687971043	    1.0445555868764569	    1.1270819791903852	    1.2113043756787012	    1.2396650297892216	    1.3121501358292844	    1.4035812568461830	    1.5186422928643466	    1.6212444694724832	    1.6906205055938628	    1.7616029323724143	    1.8542967893133169	    1.9854492275366216	    2.1243532160983984	    2.2242091584267363	    2.3337866481425995	    2.4410136729556116	    2.4711693390466909	    2.5354435036522736	    2.7848108347718563	;
   0.36048903162945439	   0.50161865665903071	   0.49200373205701786	   0.55325592089035336	   0.63695623841196802	   0.69317049455967106	   0.73857018199138702	   0.81577896727337440	   0.86999384460459661	   0.94288506229555746	    1.0419772335847246	    1.1155349799099366	    1.1423313464330234	    1.2317495161889169	    1.3234847459566772	    1.3544001676206932	    1.4333321470491938	    1.5321103944856553	    1.6555467321213369	    1.7657175885382133	    1.8402802118492594	    1.9166616793249960	    2.0163904712552703	    2.1569139820375449	    2.3039836393139721	    2.4108819819711598	    2.5305589374147721	    2.6489920398539346	    2.6823643617296593	    2.7534524864957435	    3.0190346340778205	;
   0.62503531794866574	   0.73231056958621610	   0.65515920172605835	   0.69169714252903913	   0.75966150881522343	   0.80842809667958793	   0.84838312840201480	   0.91664960631646586	   0.96786132549136272	    1.0396743122186556	    1.1412780143544061	    1.2205433919060633	    1.2495870059108676	    1.3471103432516840	    1.4473469718738292	    1.4810307519713088	    1.5667969544924047	    1.6733478453274218	    1.8056462297973532	    1.9237751427798213	    2.0038944007847559	    2.0861268247527716	    2.1938567575609227	    2.3477864296665314	    2.5131369391767633	    2.6309781311844938	    2.7599203713431861	    2.8860995946396670	    2.9213929957213454	    2.9963551980869338	    3.2796854412064507	;
   0.92606707438137070	   0.98047555564403011	   0.82443174611012404	   0.83400733884230704	   0.88359413562744771	   0.92137442688110849	   0.95225149362697370	    1.0062225812922732	    1.0495386326610583	    1.1147563340796607	    1.2188841489689075	    1.3034477476862076	    1.3344747765429010	    1.4386946519029520	    1.5451795971497888	    1.5808036250300075	    1.6712067410277638	    1.7830700684302707	    1.9221562732469049	    2.0469046543523128	    2.1317111775921123	    2.2188818347584420	    2.3335594657835870	    2.4991521589710581	    2.6780307146002125	    2.8036315804193706	    2.9389016365747347	    3.0701407228480395	    3.1070774049882881	    3.1857497125527545	    3.4866690920448478	;
    1.2654840426083196	    1.2494695393984474	    1.0027891862673317	   0.98141941033922009	    1.0106252302118015	    1.0359053443652273	    1.0567459702967004	    1.0969827223639117	    1.1317712463608145	    1.1894519836366428	    1.2923641228590494	    1.3785812154444714	    1.4108892536348263	    1.5202855703510993	    1.6318241817624837	    1.6689378129305636	    1.7626350968624576	    1.8786156965849823	    2.0238293423583036	    2.1548398248707765	    2.2440544319178590	    2.3357576109954277	    2.4567345799063136	    2.6326886154985183	    2.8226375491236468	    2.9544951915442299	    3.0954096160808544	    3.2320719462421952	    3.2707598508821389	    3.3534098422274838	    3.6712333265337960	;
    1.9942878847506142	    1.8030893000006811	    1.3561338316343010	    1.2653987185744144	    1.2552661611656704	    1.2635233552456355	    1.2767215952629638	    1.3074685177437633	    1.3337709191797302	    1.3701522064544460	    1.4436067658248062	    1.5167047732935921	    1.5458596447579744	    1.6526898401725465	    1.7692204081144316	    1.8082221485248511	    1.9071646607688717	    2.0307184154789328	    2.1864423563071007	    2.3277348992618729	    2.4245236191615720	    2.5245563091159005	    2.6568968549021204	    2.8489999380192312	    3.0548585313686787	    3.1967056343016216	    3.3482296237403428	    3.4958726611111937	    3.5377736647105227	    3.6273907988673262	    3.9751977591853835	;
    2.4141895441797279	    2.1152514519615915	    1.5489476992644919	    1.4164646127959295	    1.3838083501960210	    1.3841481916880263	    1.3942365506641259	    1.4218520322679125	    1.4449245359758733	    1.4730541029023640	    1.5266508716161959	    1.5901421997461682	    1.6162354146481825	    1.7160037192179691	    1.8344124390009391	    1.8745569190081657	    1.9770676179776656	    2.1052385801407629	    2.2663092298470868	    2.4123589832013130	    2.5125097265445882	    2.6161062722254678	    2.7532504216452440	    2.9521657904123275	    3.1653683815434794	    3.3127801947862263	    3.4703680664270902	    3.6241585401981582	    3.6678201189231534	    3.7612126540226374	    4.1235124357501629	;
    2.9909755282563486	    2.5413787820688989	    1.8066458837063417	    1.6149668521925928	    1.5504695819278973	    1.5412268024566425	    1.5463202265336220	    1.5691930899692479	    1.5873132630928699	    1.6099315010730526	    1.6408048038502698	    1.6914458373769259	    1.7137845706995074	    1.8031837877900110	    1.9202317298712750	    1.9612723829071124	    2.0675488694941673	    2.2007794791470312	    2.3680418477826031	    2.5199204029319771	    2.6236997178010579	    2.7313957687666579	    2.8740679336839352	    3.0811137788370497	    3.3034213429668640	    3.4579734242179399	    3.6237289924177545	    3.7856479050535259	    3.8316610678958494	    3.9300781455808380	    4.3098012441712816	;
    3.4970293931849263	    2.9289494358179202	    2.0369997743962758	    1.7901199089506008	    1.6956834081668748	    1.6775893964754696	    1.6777606768548488	    1.6938243167779599	    1.7067943402865617	    1.7245160368628194	    1.7456393344200252	    1.7924847827866957	    1.8137216335858402	    1.8981611332049624	    2.0110943540816177	    2.0506415125127986	    2.1523565094709638	    2.2858614845053276	    2.4635556819035833	    2.6212307908948076	    2.7278881729127149	    2.8372034174840328	    2.9801145902010480	    3.1918229971146737	    3.4220800622931602	    3.5826729054566067	    3.7552885548203294	    3.9241792432982052	    3.9721657308206160	    4.0747777666919918	    4.4676594441648225	;
    4.0754567449886343	    3.3798231676081745	    2.3016270102317344	    1.9898857251427595	    1.8604780493440609	    1.8317889044908116	    1.8265483407091108	    1.8324486847737393	    1.8394456223778100	    1.8508986456952512	    1.8705417046077712	    1.9179521188862738	    1.9390226002197029	    2.0239130285526357	    2.1303701684559120	    2.1668590426032077	    2.2626869311943949	    2.3885247066777420	    2.5711713217594188	    2.7349894841385218	    2.8459231998029977	    2.9596882229224724	    3.1085037596263101	    3.3198083070012046	    3.5564432020437380	    3.7234086723688042	    3.9030462890062090	    4.0788417559677717	    4.1287487480403211	    4.2354371403642022	    4.6414046020404038	;
    4.6270631765889938	    3.8230330358907945	    2.5601949393058749	    2.1851455642720676	    2.0228815740025450	    1.9838975917247605	    1.9733819363043852	    1.9691262196833266	    1.9712989656990543	    1.9805433440559725	    2.0000487320995779	    2.0482199295622543	    2.0699539084765712	    2.1567966937179874	    2.2580270068128310	    2.2924666801718030	    2.3800012647104056	    2.4900193894708074	    2.6762211388525343	    2.8456782306633714	    2.9607585887168599	    3.0788541733207899	    3.2334143200652328	    3.4529359980988623	    3.6891243173020265	    3.8613768001170268	    4.0463877865668332	    4.2268229745563373	    4.2779528426250399	    4.3872037081178163	    4.8053246384334880	;
    5.0137994297557373	    4.1447503420380594	    2.7481312554390063	    2.3275541738758494	    2.1430320403392784	    2.0977720544836229	    2.0829912606779066	    2.0719909463959967	    2.0711421268679437	    2.0801978006189907	    2.1061639153584442	    2.1515675170582234	    2.1724306088843952	    2.2560305238401450	    2.3542201481385256	    2.3873356107810579	    2.4655646111809375	    2.5671994198250156	    2.7537562264697377	    2.9264527764556836	    3.0445899241475627	    3.1658676261244261	    3.3246124326995159	    3.5500222272638173	    3.7871716044534427	    3.9626090765014927	    4.1507129796561335	    4.3338127234492063	    4.3856800585770195	    4.4965025304986295	    4.9219096905785831	;
    5.3594899307546200	    4.4350816294913527	    2.9181541837292508	    2.4568980504119198	    2.2537394043953811	    2.2038114439993577	    2.1848398500776036	    2.1685715956966520	    2.1659786332281685	    2.1755395657188155	    2.2079348198523543	    2.2512945828118700	    2.2710446620835398	    2.3481849302236797	    2.4420815303419197	    2.4727222646822695	    2.5439984679030778	    2.6417794961012904	    2.8250370257837467	    3.0004911055370753	    3.1208403548819916	    3.2450201488801564	    3.4075467485344713	    3.6382021712085777	    3.8795062063150176	    4.0549604785100417	    4.2454277581769313	    4.4306088788509621	    4.4830636479236645	    4.5951458083867642	    5.0260318178306758	;
    5.7017755848484928	    4.7163894857383850	    3.0835850343088862	    2.5834534307751791	    2.3638525477742793	    2.3102542444270395	    2.2874555211404228	    2.2669879425038357	    2.2638377101717650	    2.2743703022295501	    2.3106415892517980	    2.3534651315754753	    2.3719494429266357	    2.4408477602562857	    2.5272125685627809	    2.5540616653614587	    2.6222449517920152	    2.7163783027178408	    2.8954179615887203	    3.0733373780977229	    3.1957615952861245	    3.3226866252833873	    3.4888763870235051	    3.7245417583059397	    3.9708147007858341	    4.1457940899796517	    4.3382184765877367	    4.5251473126133801	    4.5780960200265692	    4.6912359977557436	    5.1264507989012298	;
    6.1070526004041596	    5.0407481035877337	    3.2758625985021879	    2.7317720439646718	    2.4958590300844015	    2.4390479647351127	    2.4126907444159555	    2.3891940552789008	    2.3866216649854115	    2.3994432954801774	    2.4368734054382628	    2.4779753085259260	    2.4943646946008631	    2.5545151653635072	    2.6269782885232220	    2.6504879792525982	    2.7162198691107338	    2.8083600466981524	    2.9774799076442173	    3.1590408349504884	    3.2844312748997653	    3.4143228979608882	    3.5847211509643482	    3.8260550315733690	    4.0779175010984527	    4.2532346987092264	    4.4474943802479290	    4.6360524967846928	    4.6894570833035232	    4.8035677305691857	    5.2424751273081096	;
    6.4830943964209338	    5.3327706430252091	    3.4510156536422869	    2.8683177223541243	    2.6206958500696795	    2.5617362193275293	    2.5334052080208243	    2.5093578536016934	    2.5084640145514703	    2.5243998484671688	    2.5619103760238113	    2.5997494093833469	    2.6139962704361333	    2.6672227536600563	    2.7252921743822132	    2.7469677407283508	    2.8079025214420037	    2.8985308489439339	    3.0538806303833610	    3.2392710193812637	    3.3671490269553539	    3.4994971043311796	    3.6736168937084472	    3.9199192963406926	    4.1767039595187310	    4.3533209913172906	    4.5488093123926063	    4.7384046542866720	    4.7920932310899449	    4.9068024722677981	    5.3477817651684436	;
    6.8043016109768981	    5.5830900589767714	    3.5982531236382398	    2.9842318757355999	    2.7290102450706124	    2.6684910051863224	    2.6393800626349209	    2.6163999936544062	    2.6176915405999521	    2.6367401543800115	    2.6752522808643699	    2.7100160003242126	    2.7229122552404266	    2.7701999379141404	    2.8185256271225394	    2.8376158522007335	    2.8899674493225529	    2.9825132345503431	    3.1350283566419694	    3.3089843984342711	    3.4386621707838905	    3.5727965106673034	    3.7493740957354640	    3.9997017200368723	    4.2605183195487699	    4.4391026436729746	    4.6351447732125006	    4.8252857142604162	    4.8791186645305826	    4.9941277501097581	    5.4360192317808096	;
    7.2288048272832661	    5.9159165602573802	    3.7911217219664644	    3.1369832823021646	    2.8750132438072158	    2.8128777337709323	    2.7836208990669302	    2.7639166880799975	    2.7696052009287184	    2.7934283675061464	    2.8358415003544772	    2.8680025233280109	    2.8800210085741638	    2.9179078330303727	    2.9550163139858592	    2.9707710621246686	    3.0178143998519840	    3.1116190684040879	    3.2712627927361777	    3.4275854903280960	    3.5439300780036072	    3.6715496544528374	    3.8499732944325218	    4.1048398412110005	    4.3707624196091386	    4.5527132437569300	    4.7492556646906285	    4.9396012754302614	    4.9934783908196847	    5.1085704961072240	    5.5504876354434298	;
    7.5518869995495308	    6.1707950259488902	    3.9389878774196179	    3.2531199646102289	    2.9880299187954060	    2.9249915534968687	    2.8960207578323796	    2.8801956550903585	    2.8901341235101317	    2.9180260947353105	    2.9647106581665632	    2.9980195584838829	    3.0110442979778163	    3.0414323777576753	    3.0756920714848071	    3.0910429869405274	    3.1372428232309004	    3.2294256611140568	    3.3916324494847419	    3.5440815082319346	    3.6550075110162119	    3.7743341952413711	    3.9380799824873791	    4.1848874387920230	    4.4544667243163900	    4.6394817903178351	    4.8360573228115573	    5.0261678614032768	    5.0799701229898631	    5.1948960752188764	    5.6360401107163671	;
    7.9989351154138282	    6.5257694681092229	    4.1451931040103451	    3.4139367206346756	    3.1467277907215325	    3.0830402672223727	    3.0551473547121755	    3.0463934347838277	    3.0628740884733432	    3.0970627625189628	    3.1511690931217475	    3.1917651362870481	    3.2072392579807607	    3.2437215622669391	    3.2769295097883520	    3.2920657762965813	    3.3395223408489949	    3.4298118323654800	    3.5871876700710956	    3.7292858326213656	    3.8294779621980020	    3.9390011952245643	    4.0935275537472569	    4.3323693187550489	    4.5886296136864280	    4.7647955580827599	    4.9560468794793815	    5.1484479616638259	    5.2029660885854083	    5.3194372199716069	    5.7670606670054001	;
    8.8796265985048812	    7.2395341821516910	    4.5634007469966473	    3.7399037987682862	    3.4764065844020222	    3.4159322573775088	    3.3947793473361361	    3.4067880502315884	    3.4375756832033204	    3.4898300484886486	    3.5681101383656073	    3.6324219240816076	    3.6521013035015799	    3.7238429587159629	    3.7882741560242237	    3.8092924529768690	    3.8613547780381050	    3.9395292908802952	    4.0556213929168461	    4.1564614127308737	    4.2323283547342685	    4.3169731411874555	    4.4452568757948212	    4.6585645754755687	    4.8836701783449081	    5.0397077482236634	    5.2048272677231067	    5.3954799358411929	    5.4508894355439592	    5.5703453103178928	    6.0305620245927178	;
    9.5483738211239029	    7.7925702478088006	    4.8897527551053610	    3.9946554383862471	    3.7372834378522657	    3.6826235993877217	    3.6710811603508597	    3.7031885722112774	    3.7456589898231942	    3.8128257164614299	    3.9089417295783071	    3.9753816098543959	    3.9986626189581167	    4.0824540672295528	    4.1603183647815980	    4.1855335929808390	    4.2476785354610502	    4.3258793195167273	    4.4283103142516858	    4.5114430402463643	    4.5734354759811984	    4.6451992157797584	    4.7554578460103238	    4.9443212005852235	    5.1311807887860965	    5.2612182569045132	    5.4022531127031792	    5.5843400738041167	    5.6397818941276663	    5.7591620897590117	    6.2279103339511117	;
    9.8114176956840993	    8.0110314623809238	    5.0185598343919118	    4.0950943660434946	    3.8396397765160630	    3.7876676763221027	    3.7803792165928671	    3.8204207846232454	    3.8674332492978469	    3.9397573681356968	    4.0422970654731909	    4.1090545219108279	    4.1342823619626445	    4.2167064240395815	    4.2963217089734345	    4.3221500178287258	    4.3863150994233333	    4.4668082502400752	    4.5651039478827968	    4.6488216665562891	    4.7073657684969845	    4.7751623181785146	    4.8789935881323352	    5.0557870366518793	    5.2277714207716786	    5.3475285125917722	    5.4792864681861886	    5.6563218288513966	    5.7117874228497811	    5.8319202097329645	    6.3038786578600750	;
    11.134326411248935	    9.1207654869758947	    5.6733149083719470	    4.6055879246540536	    4.3582238334803804	    4.3258400037678459	    4.3429650635838177	    4.4213364060476357	    4.4898263399304028	    4.5811815614444669	    4.6961596539489854	    4.7748615529961649	    4.8040453841826958	    4.9037898727189582	    4.9974559357971717	    5.0276668776272899	    5.1020692107684011	    5.1837350697682973	    5.2687614061897499	    5.3360587538813986	    5.3821340010902761	    5.4311244921014845	    5.4959148826701982	    5.5961506297544430	    5.7017390961244292	    5.7784011463881102	    5.8648748888151019	    6.0222269830051056	    6.0782618982431673	    6.1993194354030337	    6.6747909417265596	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('LMDV_TIER_3_REG');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
